<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'order_type_id', 'status_id', 'is_connected', 'note');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function status()
    {
        return $this->belongsTo('Status');
    }

    public function order_type()
    {
        return $this->belongsTo('OrderType');
    }

    public function answers()
    {
        return $this->hasMany('Answer');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

}